import UIKit
import PlaygroundSupport

//make a Backdrop for the action to come
let frame = CGRect(x: 0, y: 0, width: 200, height: 200)
let myView = UIView(frame: frame)
myView.backgroundColor = #colorLiteral(red: 0.976470589637756, green: 0.850980401039124, blue: 0.549019634723663, alpha: 1.0)

//create a button
let myButton = UIButton(type: .roundedRect)
myButton.setTitle("Touch me!", for: .normal)
myButton.setTitleColor(#colorLiteral(red: 0.239215686917305, green: 0.674509823322296, blue: 0.968627452850342, alpha: 1.0), for: .normal)
myButton.frame = CGRect(x: 0, y: 0, width: 100, height: 50)
myButton.center = CGPoint(x: frame.midX, y: frame.midY)

//attach button to containerview
myView.addSubview(myButton)

// Show the container view in the Assistant Editor
PlaygroundPage.current.liveView = myView

let animator = UIViewPropertyAnimator(duration: 5, dampingRatio: 1, animations: {
    myButton.frame.origin.x = 100
})
animator.startAnimation()

